import java.security.Security;
import java.util.HashMap;
import java.util.Map;

import net.catcert.DigitalSignatureServiceStub;

import org.apache.xmlbeans.XmlOptions;
import org.w3.www._2000._09.xmldsig.DigestMethodType;
import org.w3.www._2000._09.xmldsig.KeyInfoType;
import org.w3.www._2000._09.xmldsig.X509DataType;

import schema.core._0._1.dss.tc.names.oasis.SignRequestDocument;
import schema.core._0._1.dss.tc.names.oasis.SignResponseDocument;
import schema.core._0._1.dss.tc.names.oasis.DocumentHashDocument.DocumentHash;
import schema.core._0._1.dss.tc.names.oasis.InputDocumentsDocument.InputDocuments;
import schema.core._0._1.dss.tc.names.oasis.KeySelectorDocument.KeySelector;
import schema.core._0._1.dss.tc.names.oasis.OptionalInputsDocument.OptionalInputs;
import schema.core._0._1.dss.tc.names.oasis.SignRequestDocument.SignRequest;

import com.bs.psis.test.utils.Utils;

public class GeneracioTimestamp {

	public static void main(String args[]) throws Exception {

		// Configuraci socket TSL
		// Client keystore init
		System.setProperty("javax.net.ssl.keyStore","C:\\psisauth.p12");
		// Here we define the type of keystore jks, pkcs12 or the one containing the user keys
		System.setProperty("javax.net.ssl.keyStoreType","pkcs12");
		// The keystore password
		System.setProperty("javax.net.ssl.keyStorePassword", "sIikZSmz");

		// Cert must be added to cacerts using keytool or specified here
		System.setProperty("javax.net.ssl.trustStore","C:\\Program Files\\Java\\jre1.5.0_14\\lib\\security\\cacerts_pre");
		System.setProperty("javax.net.ssl.trustStoreType", "JKS");
		System.setProperty("javax.net.ssl.trustStorePassord", "changeit");
		//System.setProperty("javax.net.debug", "ssl");

		// Security Provider
		System.setProperty("java.protocol.handler.pkgs","com.sun.net.ssl.internal.www.protocol");
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
		
		
		XmlOptions options = new XmlOptions();

		Map namespacePrefixes = new HashMap();
		namespacePrefixes.put("xss", "urn:oasis:names:tc:dss:1.0:profiles:XSS");
		namespacePrefixes.put("dss", "urn:oasis:names:tc:dss:1.0:core:schema");
		options.setSaveSuggestedPrefixes(namespacePrefixes);

		SignRequestDocument requestDocument = SignRequestDocument.Factory.newInstance(options);
		SignRequest request = requestDocument.addNewSignRequest();
		request.setProfile("urn:oasis:names:tc:dss:1.0:profiles:timestamping");

		// Certificat amb que es generar la signatura o timestamp
		byte[] certificate = Utils.readBase64File("timestamp-certificate.dat");
		
		// Digest
		byte[] digest = Utils.readBase64File("hash.dat");

		// Creaci de l'element amb el document per generar el timestamp
		InputDocuments inpDocuments = InputDocuments.Factory.newInstance();
		DocumentHash document = inpDocuments.addNewDocumentHash();
		DigestMethodType digestMethod = document.addNewDigestMethod();
		digestMethod.setAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
		document.setDigestValue(digest);
		document.setID("docID");
		request.setInputDocuments(inpDocuments);

		// Creaci de l'element amb els parmetres opcionals necessaris per generar el timestamp
		OptionalInputs optional = request.addNewOptionalInputs();
		KeySelector selector = optional.addNewKeySelector();
		KeyInfoType key = selector.addNewKeyInfo();
		X509DataType x509data = key.addNewX509Data();

		// S'afegeix el certificat de TSA de CATCert en Base64		
		x509data.setX509Certificate(certificate);

		// Tipus de signatura disponibles
		// TimeStamp amb signatura CMS/CAdes: 	urn:ietf:rfc:3161
		// TimeStamp amb signatura XMLDsig: 	oasis:names:tc:dss:1.0:core:schema:XMLTimeStampToken
		// TimeStamp amb signatura XAdES:		oasis:names:tc:dss:1.0:core:schema:XAdESTimeStampToken
		String type = "oasis:names:tc:dss:1.0:core:schema:XMLTimeStampToken";
		optional.setSignatureType(type);
		
		// Visualitzaci de la petici
		System.out.println(requestDocument.xmlText(options));

		// Execuci del servei
		DigitalSignatureServiceStub digitalSignatureServiceStub = new DigitalSignatureServiceStub("https://psis.catcert.net/psis/catcert/dss");
		requestDocument = SignRequestDocument.Factory.parse(requestDocument.newInputStream());		
		SignResponseDocument responseDocument = digitalSignatureServiceStub.sign(requestDocument);

		// visualitzaci de la resposta
		System.out.println(responseDocument.xmlText(options));

	}
}